/*
 * Decompiled with CFR 0.152.
 */
package eduni.simdiag;

import eduni.simdiag.Controls;
import eduni.simdiag.Diagram;
import eduni.simdiag.Key;
import eduni.simdiag.Labels;
import eduni.simdiag.TraceEventObject;
import eduni.simdiag.TraceListener;
import eduni.simdiag.TraceLoader;
import eduni.simdiag.Traceable;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.util.ArrayList;
import java.util.List;

public class TimingDiagram
extends Applet
implements TraceListener,
Traceable,
Runnable {
    transient Thread thread;
    Diagram diag;
    Labels labels;
    Key keys;
    Scrollbar hscroll;
    private List traceListeners = new ArrayList();
    private TraceEventObject lastTraceEvent;

    public TimingDiagram() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        this.init();
    }

    public synchronized void addTraceListener(TraceListener traceListener) {
        this.traceListeners.add(traceListener);
    }

    public synchronized void removeTraceListener(TraceListener traceListener) {
        this.traceListeners.remove(traceListener);
    }

    public void handleTrace(TraceEventObject traceEventObject) {
        this.lastTraceEvent = traceEventObject;
        if (traceEventObject.getCmd() == 0) {
            this.diag.processTrace(traceEventObject.getLine());
        } else if (traceEventObject.getCmd() == 1) {
            this.diag.reLayout();
        } else if (traceEventObject.getCmd() == 5) {
            this.diag.display();
            this.labels.repaint();
            this.keys.repaint();
        }
        this.forwardTrace(traceEventObject);
    }

    public void forwardTrace(TraceEventObject traceEventObject) {
        List list;
        TimingDiagram timingDiagram = this;
        synchronized (timingDiagram) {
            list = (List)((ArrayList)this.traceListeners).clone();
        }
        TraceEventObject traceEventObject2 = new TraceEventObject((Object)this, traceEventObject);
        int n = 0;
        while (n < list.size()) {
            TraceListener traceListener = (TraceListener)list.get(n);
            traceListener.handleTrace(traceEventObject2);
            ++n;
        }
    }

    public void display() {
        this.diag.repaint();
        this.labels.repaint();
        this.keys.repaint();
    }

    public void init() {
        this.diag = new Diagram();
        this.labels = new Labels(this.diag.getEntries());
        Scrollbar scrollbar = new Scrollbar(1, 0, 1000, 0, 0);
        this.hscroll = new Scrollbar(0, 0, 1000, 0, 0);
        this.diag.set_sb(this.hscroll);
        this.keys = new Key(this.diag.getEntries().getTypes());
        Controls controls = new Controls(this.diag);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setFont(new Font("TimesRoman", 0, 14));
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 10.0;
        this.add(this.labels);
        gridBagLayout.setConstraints(this.labels, gridBagConstraints);
        gridBagConstraints.weightx = 10.0;
        this.add(this.diag);
        gridBagLayout.setConstraints(this.diag, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.add(scrollbar);
        gridBagLayout.setConstraints(scrollbar, gridBagConstraints);
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.weighty = 0.0;
        this.add(panel);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        gridBagConstraints.weightx = 10.0;
        this.add(this.hscroll);
        gridBagLayout.setConstraints(this.hscroll, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.add(panel2);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 5.0;
        gridBagConstraints.gridwidth = 0;
        this.add(this.keys);
        gridBagLayout.setConstraints(this.keys, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        this.add(controls);
        gridBagLayout.setConstraints(controls, gridBagConstraints);
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Timing Diagram Example");
        TimingDiagram timingDiagram = new TimingDiagram();
        TraceLoader traceLoader = new TraceLoader("http://www.dcs.ed.ac.uk/home/fwh/tmp.trace");
        traceLoader.addTraceListener(timingDiagram);
        traceLoader.startLoading();
        frame.add("Center", timingDiagram);
        frame.pack();
        ((Component)frame).setSize(600, 300);
        frame.show();
    }
}

