/*
 * Decompiled with CFR 0.152.
 */
package eduni.simdiag;

import eduni.simdiag.GraphEqn;
import eduni.simdiag.GraphEventObject;
import eduni.simdiag.GraphListener;
import eduni.simdiag.GraphPanel;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;

public class GraphDiagram
extends Applet
implements GraphListener,
Runnable {
    transient Thread thread;
    GraphPanel diag;
    private List graphListeners = new ArrayList();

    public GraphDiagram() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        this.init();
    }

    public synchronized void addGraphListener(GraphListener graphListener) {
        this.graphListeners.add(graphListener);
    }

    public synchronized void removeGraphListener(GraphListener graphListener) {
        this.graphListeners.remove(graphListener);
    }

    public void handleGraph(GraphEventObject graphEventObject) {
        graphEventObject.doit(this);
        this.forwardGraph(graphEventObject);
    }

    public void forwardGraph(GraphEventObject graphEventObject) {
        List list;
        GraphDiagram graphDiagram = this;
        synchronized (graphDiagram) {
            list = (List)((ArrayList)this.graphListeners).clone();
        }
        int n = 0;
        while (n < list.size()) {
            GraphListener graphListener = (GraphListener)list.get(n);
            graphListener.handleGraph(graphEventObject);
            ++n;
        }
    }

    public void init() {
        this.setLayout(new GridLayout(1, 1));
        this.diag = new GraphPanel();
        this.add(this.diag);
    }

    public GraphPanel get_diag() {
        return this.diag;
    }

    public void clear() {
        this.diag.clear();
        this.diag.repaint();
    }

    public void setAxes(String string, String string2) {
        System.out.println("Setting axes to " + string + " " + string2);
        this.diag.setAxes(string, string2);
    }

    public void setScale(double d, double d2, double d3, double d4) {
        this.diag.setScale(d, d2, d3, d4);
    }

    public void data(String string, double d, double d2) {
        System.out.println("Data " + string + " " + d + " " + d2);
        this.diag.data(string, d, d2);
    }

    public void display() {
        this.diag.repaint();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("Graph Diagram Example");
        GraphDiagram graphDiagram = new GraphDiagram();
        GraphEqn graphEqn = new GraphEqn();
        graphEqn.addGraphListener(graphDiagram);
        graphEqn.startRunning();
        frame.add("Center", graphDiagram);
        frame.pack();
        ((Component)frame).setSize(600, 300);
        frame.show();
    }
}

