/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import eduni.simjava.Sim_event;
import gridsim.Accumulator;
import gridsim.GridSim;
import gridsim.Stat;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public class GridStatistics
extends GridSim {
    private boolean active_;
    private PrintWriter outFile_;
    private LinkedList statList_;
    private LinkedList statSortByCategoryData_;
    private String[] excludeFromFile_;
    private String[] excludeFromProcessing_;

    public GridStatistics(String string) throws Exception {
        super(string);
        this.active_ = false;
        this.outFile_ = null;
        this.statList_ = null;
        this.statSortByCategoryData_ = null;
        this.excludeFromFile_ = null;
        this.excludeFromProcessing_ = null;
    }

    public GridStatistics(String string, String string2, boolean bl, String[] stringArray, String[] stringArray2) throws Exception {
        super(string);
        this.active_ = true;
        try {
            FileWriter fileWriter = new FileWriter(string2, bl);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            this.outFile_ = new PrintWriter(bufferedWriter);
            this.statList_ = new LinkedList();
            this.excludeFromFile_ = stringArray;
            this.excludeFromProcessing_ = stringArray2;
            this.statSortByCategoryData_ = null;
        }
        catch (IOException iOException) {
            System.out.println("GridStatistics() : Error - unable to open " + string2);
        }
    }

    public Accumulator accumulate(String string) {
        LinkedList linkedList = this.statSortByCategoryData_;
        Accumulator accumulator = new Accumulator();
        int n = Collections.binarySearch(linkedList, new Stat(0.0, string, "", ""), new OrderByCategory());
        if (n < 0) {
            return accumulator;
        }
        Stat stat = (Stat)linkedList.get(n);
        accumulator.add(new Double(stat.getData()));
        int n2 = 0;
        for (n2 = n + 1; n2 < linkedList.size() && (stat = (Stat)linkedList.get(n2)).getCategory().equals(string); ++n2) {
            accumulator.add(new Double(stat.getData()));
        }
        for (n2 = n - 1; n2 >= 0 && (stat = (Stat)linkedList.get(n2)).getCategory().equals(string); --n2) {
            accumulator.add(new Double(stat.getData()));
        }
        return accumulator;
    }

    public Accumulator accumulate(String string, String string2) {
        LinkedList linkedList = this.statSortByCategoryData_;
        Accumulator accumulator = new Accumulator();
        LinkedList<Times> linkedList2 = new LinkedList<Times>();
        int n = Collections.binarySearch(linkedList, new Stat(0.0, string2, "", ""), new OrderByCategory());
        if (n < 0) {
            return accumulator;
        }
        Stat stat = (Stat)linkedList.get(n);
        int n2 = Integer.parseInt(stat.getName().substring(stat.getName().indexOf(95) + 1));
        linkedList2.add(new Times(n2, Integer.parseInt(stat.getData())));
        int n3 = 0;
        for (n3 = n + 1; n3 < linkedList.size() && (stat = (Stat)linkedList.get(n3)).getCategory().equals(string2); ++n3) {
            n2 = Integer.parseInt(stat.getName().substring(stat.getName().indexOf(95) + 1));
            linkedList2.add(new Times(n2, Integer.parseInt(stat.getData())));
        }
        for (n3 = n - 1; n3 >= 0 && (stat = (Stat)linkedList.get(n3)).getCategory().equals(string2); --n3) {
            n2 = Integer.parseInt(stat.getName().substring(stat.getName().indexOf(95) + 1));
            linkedList2.add(new Times(n2, Integer.parseInt(stat.getData())));
        }
        Collections.sort(linkedList2, new OrderByIndex());
        n = Collections.binarySearch(linkedList, new Stat(0.0, string, "", ""), new OrderByCategory());
        if (n < 0) {
            return accumulator;
        }
        stat = (Stat)linkedList.get(n);
        n2 = Integer.parseInt(stat.getName().substring(stat.getName().indexOf(95) + 1));
        int n4 = Collections.binarySearch(linkedList2, new Times(n2, 0), new OrderByIndex());
        accumulator.add(new Double(stat.getData()), ((Times)linkedList2.get(n4)).getValue());
        for (n3 = n + 1; n3 < linkedList.size() && (stat = (Stat)linkedList.get(n3)).getCategory().equals(string); ++n3) {
            n2 = Integer.parseInt(stat.getName().substring(stat.getName().indexOf(95) + 1));
            n4 = Collections.binarySearch(linkedList2, new Times(n2, 0), new OrderByIndex());
            accumulator.add(new Double(stat.getData()), ((Times)linkedList2.get(n4)).getValue());
        }
        for (n3 = n - 1; n3 >= 0 && (stat = (Stat)linkedList.get(n3)).getCategory().equals(string); --n3) {
            n2 = Integer.parseInt(stat.getName().substring(stat.getName().indexOf(95) + 1));
            n4 = Collections.binarySearch(linkedList2, new Times(n2, 0), new OrderByIndex());
            accumulator.add(new Double(stat.getData()), ((Times)linkedList2.get(n4)).getValue());
        }
        return accumulator;
    }

    public void body() {
        Sim_event sim_event = new Sim_event();
        this.sim_get_next(sim_event);
        while (sim_event.get_tag() != -1) {
            if (this.active_) {
                switch (sim_event.get_tag()) {
                    case 9: {
                        if (sim_event.get_data() == null) break;
                        this.recordStat((Stat)sim_event.get_data());
                        break;
                    }
                    case 11: {
                        this.returnAccStatByCategory(sim_event);
                        break;
                    }
                    default: {
                        System.out.println("GridStatistics.body() : Unable to handle request from GridSimTags with constant number " + sim_event.get_tag());
                    }
                }
            }
            this.sim_get_next(sim_event);
        }
        if (this.active_) {
            this.outFile_.close();
        }
    }

    public void RecordStat(Stat stat) {
        this.recordStat(stat);
    }

    public void recordStat(Stat stat) {
        boolean bl = true;
        int n = 0;
        int n2 = this.excludeFromProcessing_.length;
        for (n = 0; n < n2; ++n) {
            if (!(stat.getCategory() + ".").startsWith(this.excludeFromProcessing_[n] + ".")) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.statList_.add(stat);
        }
        bl = true;
        n2 = this.excludeFromFile_.length;
        for (n = 0; n < n2; ++n) {
            if (!(stat.getCategory() + ".").startsWith(this.excludeFromFile_[n] + ".")) continue;
            bl = false;
            break;
        }
        if (bl) {
            this.outFile_.println(stat.toString());
        }
    }

    public void ReturnAccStatByCategory(Sim_event sim_event) {
        this.returnAccStatByCategory(sim_event);
    }

    public void returnAccStatByCategory(Sim_event sim_event) {
        this.statSortByCategoryData_ = new LinkedList(this.statList_);
        Collections.sort(this.statSortByCategoryData_, new OrderByCategoryData());
        String string = (String)sim_event.get_data();
        Accumulator accumulator = this.accumulate(string);
        super.send(sim_event.get_src(), 0.0, sim_event.get_tag(), (Object)accumulator);
    }

    private class OrderByIndex
    implements Comparator {
        public int compare(Object object, Object object2) throws ClassCastException {
            Integer n = new Integer(((Times)object).getIndex());
            Integer n2 = new Integer(((Times)object2).getIndex());
            return n.compareTo(n2);
        }
    }

    private class Times {
        private int index_;
        private int val_;

        public Times(int n, int n2) {
            this.index_ = n;
            this.val_ = n2;
        }

        public int getIndex() {
            return this.index_;
        }

        public int getValue() {
            return this.val_;
        }
    }

    private class OrderByCategory
    implements Comparator {
        public int compare(Object object, Object object2) throws ClassCastException {
            String string = ((Stat)object).getCategory();
            String string2 = ((Stat)object2).getCategory();
            return string.compareTo(string2);
        }
    }

    private class OrderByCategoryName
    implements Comparator {
        public int compare(Object object, Object object2) throws ClassCastException {
            String string;
            String string2 = ((Stat)object).getCategory();
            if (string2.equals(string = ((Stat)object2).getCategory())) {
                String string3 = ((Stat)object).getName();
                String string4 = ((Stat)object2).getName();
                return string3.compareTo(string4);
            }
            return string2.compareTo(string);
        }
    }

    private class OrderByCategoryData
    implements Comparator {
        public int compare(Object object, Object object2) throws ClassCastException {
            String string;
            String string2 = ((Stat)object).getCategory();
            if (string2.equals(string = ((Stat)object2).getCategory())) {
                String string3 = ((Stat)object).getData();
                String string4 = ((Stat)object2).getData();
                return string3.compareTo(string4);
            }
            return string2.compareTo(string);
        }
    }

    private class OrderByCategoryNameData
    implements Comparator {
        public int compare(Object object, Object object2) throws ClassCastException {
            String string;
            String string2 = ((Stat)object).getCategory();
            if (string2.equals(string = ((Stat)object2).getCategory())) {
                String string3;
                String string4 = ((Stat)object).getName();
                if (string4.equals(string3 = ((Stat)object2).getName())) {
                    String string5 = ((Stat)object).getData();
                    String string6 = ((Stat)object2).getData();
                    return string5.compareTo(string6);
                }
                return string4.compareTo(string3);
            }
            return string2.compareTo(string);
        }
    }
}

