/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

import eduni.simjava.Sim_event;
import eduni.simjava.Sim_system;
import gridsim.Accumulator;
import gridsim.AllocPolicy;
import gridsim.GridSim;
import gridsim.Gridlet;
import gridsim.IO_data;
import gridsim.ResourceCalendar;
import gridsim.ResourceCharacteristics;
import gridsim.SpaceShared;
import gridsim.TimeShared;
import java.util.LinkedList;

public class GridResource
extends GridSim {
    private ResourceCharacteristics resource_;
    private ResourceCalendar resCalendar_;
    private AllocPolicy policy_;
    private int policyType_;
    private int resourceID_;
    private final String resourceName_;

    public GridResource(String string, double d, long l, ResourceCharacteristics resourceCharacteristics, double d2, double d3, double d4, LinkedList linkedList, LinkedList linkedList2) throws Exception {
        super(string, d);
        this.resource_ = resourceCharacteristics;
        this.resourceName_ = string;
        this.resCalendar_ = new ResourceCalendar(this.resource_.getResourceTimeZone(), d2, d3, d4, linkedList, linkedList2, l);
        this.policy_ = null;
        this.init();
    }

    public GridResource(String string, double d, ResourceCharacteristics resourceCharacteristics, ResourceCalendar resourceCalendar) throws Exception {
        super(string, d);
        this.resource_ = resourceCharacteristics;
        this.resourceName_ = string;
        this.resCalendar_ = resourceCalendar;
        this.policy_ = null;
        this.init();
    }

    public GridResource(String string, double d, ResourceCharacteristics resourceCharacteristics, ResourceCalendar resourceCalendar, AllocPolicy allocPolicy) throws Exception {
        super(string, d);
        this.resource_ = resourceCharacteristics;
        this.resourceName_ = string;
        this.resCalendar_ = resourceCalendar;
        this.policy_ = allocPolicy;
        this.init();
    }

    public void body() {
        super.send(this.output, 0.0, 2, (Object)new IO_data(new Integer(this.resourceID_), 4L, GridSim.getGridInfoServiceEntityId()));
        Sim_event sim_event = new Sim_event();
        while (Sim_system.running()) {
            super.sim_get_next(sim_event);
            if (sim_event.get_tag() == -1) {
                this.policy_.setEndSimulation();
                break;
            }
            this.processEvent(sim_event);
        }
        super.terminateIOEntities();
    }

    public void SpaceShare_AllocatePEtoGridlet(Gridlet gridlet) {
        this.spaceShared_AllocatePEtoGridlet(gridlet);
    }

    public void spaceShared_AllocatePEtoGridlet(Gridlet gridlet) {
        System.out.println("GridResource.spaceShared_AllocatePEtoGridlet() is OBSOLETE since GridSim 2.2. Don't use this method.");
    }

    private void init() throws Exception {
        if (this.resource_.getNumPE() == 0) {
            throw new Exception("GridResource() : Error - this entity has no PEs. Therefore, can't process any Gridlets.");
        }
        this.resourceID_ = super.get_id();
        this.resource_.setResourceID(this.resourceID_);
        if (this.policy_ == null) {
            this.policyType_ = this.resource_.getResourceAllocationPolicy();
            switch (this.policyType_) {
                case 0: {
                    this.policy_ = new TimeShared(this.resourceName_, "TimeShared");
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.policy_ = new SpaceShared(this.resourceName_, "SpaceShared");
                    break;
                }
                default: {
                    throw new Exception("GridResource: Invalid Resource Allocation policy.");
                }
            }
        }
        this.policy_.init(this.resource_, this.resCalendar_, this.output);
    }

    private void processEvent(Sim_event sim_event) {
        int n = -1;
        switch (sim_event.get_tag()) {
            case 4: {
                n = (Integer)sim_event.get_data();
                super.send(this.output, 0.0, sim_event.get_tag(), (Object)new IO_data(this.resource_, this.resource_.getByteSize(), n));
                break;
            }
            case 5: {
                n = (Integer)sim_event.get_data();
                super.send(this.output, 0.0, sim_event.get_tag(), (Object)new IO_data(this.policy_.getTotalLoad(), Accumulator.getByteSize(), n));
                break;
            }
            case 6: {
                this.processGridletSubmit(sim_event, false);
                break;
            }
            case 7: {
                this.processGridletSubmit(sim_event, true);
                break;
            }
            case 9: {
                this.processGridlet(sim_event, 9);
                break;
            }
            case 11: {
                this.processGridlet(sim_event, 11);
                break;
            }
            case 12: {
                this.processGridlet(sim_event, 12);
                break;
            }
            case 13: {
                this.processGridlet(sim_event, 13);
                break;
            }
            case 14: {
                this.processGridlet(sim_event, 14);
                break;
            }
            case 15: {
                this.processGridletMove(sim_event, 15);
                break;
            }
            case 16: {
                this.processGridletMove(sim_event, 16);
                break;
            }
            case 10: {
                this.processGridletStatus(sim_event);
                break;
            }
            default: {
                System.out.println(this.resourceName_ + ".body(): Unable to " + "handle request from GridSimTags " + "with constant number " + sim_event.get_tag());
            }
        }
    }

    private void processGridletStatus(Sim_event sim_event) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        try {
            int[] nArray = (int[])sim_event.get_data();
            n = nArray[0];
            n2 = nArray[1];
            n3 = this.policy_.gridletStatus(n, n2);
        }
        catch (ClassCastException classCastException) {
            try {
                Gridlet gridlet = (Gridlet)sim_event.get_data();
                n = gridlet.getGridletID();
                n2 = gridlet.getUserID();
                n3 = this.policy_.gridletStatus(n, n2);
            }
            catch (Exception exception) {
                System.out.println(this.resourceName_ + ": Error in processing GridSimTags.GRIDLET_STATUS");
                System.out.println(exception.getMessage());
                return;
            }
        }
        catch (Exception exception) {
            System.out.println(this.resourceName_ + ": Error in processing GridSimTags.GRIDLET_STATUS");
            System.out.println(exception.getMessage());
            return;
        }
        int n4 = 10 + n;
        super.send(this.output, 0.0, n4, (Object)new IO_data(new Integer(n3), 8L, n2));
    }

    private void processGridlet(Sim_event sim_event, int n) {
        int n2 = 0;
        int n3 = 0;
        try {
            int[] nArray = (int[])sim_event.get_data();
            n2 = nArray[0];
            n3 = nArray[1];
        }
        catch (ClassCastException classCastException) {
            try {
                Gridlet gridlet = (Gridlet)sim_event.get_data();
                n2 = gridlet.getGridletID();
                n3 = gridlet.getUserID();
            }
            catch (Exception exception) {
                System.out.println(this.resourceName_ + ": Error in processing Gridlet");
                System.out.println(exception.getMessage());
                return;
            }
        }
        catch (Exception exception) {
            System.out.println(this.resourceName_ + ": Error in processing Gridlet");
            System.out.println(exception.getMessage());
            return;
        }
        switch (n) {
            case 9: {
                this.policy_.gridletCancel(n2, n3);
                break;
            }
            case 11: {
                this.policy_.gridletPause(n2, n3, false);
                break;
            }
            case 12: {
                this.policy_.gridletPause(n2, n3, true);
                break;
            }
            case 13: {
                this.policy_.gridletResume(n2, n3, false);
                break;
            }
            case 14: {
                this.policy_.gridletResume(n2, n3, true);
                break;
            }
        }
    }

    private void processGridletMove(Sim_event sim_event, int n) {
        boolean bl = false;
        if (n == 16) {
            bl = true;
        }
        try {
            int[] nArray = (int[])sim_event.get_data();
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            this.policy_.gridletMove(n2, n3, n4, bl);
        }
        catch (Exception exception) {
            System.out.println(this.resourceName_ + ": Error in moving a Gridlet.");
            System.out.println(exception.getMessage());
        }
    }

    private void processGridletSubmit(Sim_event sim_event, boolean bl) {
        Gridlet gridlet = (Gridlet)sim_event.get_data();
        if (gridlet.isFinished()) {
            System.out.println(this.resourceName_ + ": Error - Gridlet #" + gridlet.getGridletID() + " for User #" + gridlet.getUserID() + " is already finished.");
            if (bl) {
                int n = 7 + gridlet.getGridletID();
                super.send(this.output, 0.0, n, (Object)new IO_data(new Boolean(false), 8L, gridlet.getUserID()));
            }
            super.send(this.output, 0.0, 8, (Object)new IO_data(gridlet, gridlet.getGridletOutputSize(), gridlet.getUserID()));
            return;
        }
        gridlet.setResourceParameter(this.resourceID_, this.resource_.getCostPerSec());
        this.policy_.gridletSubmit(gridlet, bl);
    }
}

