/*
 * Decompiled with CFR 0.152.
 */
package gridsim;

public class Accumulator {
    private int n_ = 0;
    private double mean_ = Double.NaN;
    private double sqrMean_ = Double.NaN;
    private double min_ = Double.NaN;
    private double max_ = Double.NaN;
    private double last_ = Double.NaN;

    public void add(double d, int n) {
        if (n < 1) {
            return;
        }
        this.last_ = d;
        if (this.n_ <= 0) {
            this.n_ += n;
            this.mean_ = d;
            this.min_ = d;
            this.max_ = d;
            this.sqrMean_ = d * d;
        } else {
            this.n_ += n;
            this.mean_ = ((double)(this.n_ - n) * this.mean_ + d * (double)n) / (double)this.n_;
            this.sqrMean_ = ((double)(this.n_ - n) * this.sqrMean_ + d * d * (double)n) / (double)this.n_;
            if (d < this.min_) {
                this.min_ = d;
            }
            if (d > this.max_) {
                this.max_ = d;
            }
        }
    }

    public void add(double d) {
        this.add(d, 1);
    }

    public double mean() {
        return this.getMean();
    }

    public double getMean() {
        return this.mean_;
    }

    public double sd() {
        return this.getStandardDeviation();
    }

    public double getStandardDeviation() {
        return this.sqrMean_ - this.mean_ * this.mean_;
    }

    public double min() {
        return this.getMin();
    }

    public double getMin() {
        return this.min_;
    }

    public double max() {
        return this.getMax();
    }

    public double getMax() {
        return this.max_;
    }

    public double last() {
        return this.getLast();
    }

    public double getLast() {
        return this.last_;
    }

    public int count() {
        return this.getCount();
    }

    public int getCount() {
        return this.n_;
    }

    public double sum() {
        return this.getSum();
    }

    public double getSum() {
        return (double)this.n_ * this.mean_;
    }

    public static int ByteSize() {
        return Accumulator.getByteSize();
    }

    public static int getByteSize() {
        int n = 4;
        int n2 = 40;
        return n + n2;
    }
}

