/*
 * Decompiled with CFR 0.152.
 */
package gridbroker;

import eduni.simjava.Sim_system;
import gridbroker.Broker;
import gridbroker.Experiment;
import gridsim.Accumulator;
import gridsim.GridSim;
import gridsim.GridSimRandom;
import gridsim.Gridlet;
import java.util.Random;

public class UserEntity
extends GridSim {
    private Experiment expSend_;
    private Experiment expReceived_;
    private String brokerName_;
    private Random randomDelay_;
    private double successiveExpDelay_;
    private boolean resultDisplay_;
    private Accumulator gridletCompletionFactor_;
    private Accumulator timeUtilizationFactor_;
    private Accumulator budgetUtilizationFactor_;

    public UserEntity(String string, Experiment experiment, double d, long l, double d2, boolean bl) throws Exception {
        super(string);
        this.randomDelay_ = new Random(l);
        this.brokerName_ = "Broker_" + string;
        new Broker(this.brokerName_, d);
        this.expSend_ = experiment;
        this.successiveExpDelay_ = d2;
        this.resultDisplay_ = bl;
        this.gridletCompletionFactor_ = new Accumulator();
        this.timeUtilizationFactor_ = new Accumulator();
        this.budgetUtilizationFactor_ = new Accumulator();
        this.expReceived_ = null;
    }

    public void body() {
        double d = 0.1;
        super.recordStatistics("USER.B_factor", this.expSend_.getBudgetFactor());
        super.recordStatistics("USER.D_factor", this.expSend_.getDeadlineFactor());
        super.gridSimHold(GridSimRandom.real(this.successiveExpDelay_, d, d, this.randomDelay_.nextDouble()));
        super.send(this.brokerName_, 0.0, 1, (Object)this.expSend_);
        this.expReceived_ = (Experiment)super.receiveEventObject();
        this.expReceived_.setEndTime();
        this.gridletCompletionFactor_.add(this.expReceived_.getNumSuccessfulGridlet());
        this.timeUtilizationFactor_.add(this.expReceived_.getEndTime() - this.expReceived_.getStartTime());
        this.budgetUtilizationFactor_.add(this.expReceived_.getBudgetSpent());
        super.recordStatistics("USER.Experiment.No", this.expReceived_.getExperimentID());
        super.recordStatistics("USER.Experiment.StartTime", this.expReceived_.getStartTime());
        super.recordStatistics("USER.Experiment.EndTime", this.expReceived_.getEndTime());
        super.recordStatistics("USER.Experiment.GridletCompletion", this.expReceived_.getNumSuccessfulGridlet());
        super.recordStatistics("USER.Experiment.TimeUtilization", this.expReceived_.getEndTime() - this.expReceived_.getStartTime());
        super.recordStatistics("USER.Experiment.BudgetUtilization", this.expReceived_.getBudgetSpent());
        if (this.resultDisplay_) {
            System.out.println(super.get_name() + ":: Experiment Schedule");
            System.out.println("-----------------------------------------");
            System.out.println("UserID | GridLetID | Status | Resource ID | GL_SubmissionTime | GL_StartTime | Gl_FinishTime | GL_actualCPUtime | GL_WallClockTime | Resource Name");
            for (int i = 0; i < this.expSend_.getGridletList().size(); ++i) {
                Gridlet gridlet = (Gridlet)this.expSend_.getGridletList().get(i);
                System.out.print(super.get_name() + " | " + gridlet.getGridletID() + " | " + gridlet.getGridletStatusString() + " | " + gridlet.getResourceID() + " | " + gridlet.getSubmissionTime() + " | " + gridlet.getExecStartTime() + " | " + gridlet.getFinishTime() + " | " + gridlet.getActualCPUTime() + " | " + gridlet.getWallClockTime() + " | ");
                if (gridlet.getGridletStatus() == 0) {
                    System.out.println("No Resource Assigned");
                    continue;
                }
                String string = Sim_system.get_entity(gridlet.getResourceID()).get_name();
                System.out.println(string);
            }
            System.out.println("******** Experiment Report ********");
            System.out.println("No. of Gridlets: " + this.expReceived_.getNumGridlet());
            System.out.println("Deadline Factor: " + this.expReceived_.getDeadlineFactor());
            System.out.println("Deadline: " + this.expReceived_.getDeadline());
            System.out.println("Deadline Time: " + this.expReceived_.getDeadlineTime());
            System.out.println("Budget Factor: " + this.expReceived_.getBudgetFactor());
            System.out.println("Budget: " + this.expReceived_.getBudget());
            System.out.println("Stratergy: " + this.expReceived_.getOptimizationStrategyName());
            System.out.println("Start Time: " + this.expReceived_.getStartTime());
            System.out.println("End Time: " + this.expReceived_.getEndTime());
            System.out.println("Budget Spent: " + this.expReceived_.getBudgetSpent());
            System.out.println("Gridlets Executed: " + this.expReceived_.getNumSuccessfulGridlet());
            System.out.println("Gridlet Completion Factor: " + this.expReceived_.getGridletCompletionFactor());
        }
        super.recordStatistics("*.USER.GridletCompletion", this.gridletCompletionFactor_.getMean());
        super.recordStatistics("*.USER.TimeUtilization", this.timeUtilizationFactor_.getMean());
        super.recordStatistics("*.USER.BudgetUtilization", this.budgetUtilizationFactor_.getMean());
        System.out.println("GridletCompletion: " + (int)this.gridletCompletionFactor_.getMean() + "\t" + "TimeUtilization: " + (int)this.timeUtilizationFactor_.getMean() + "\t" + "BudgetUtilization: " + (int)this.budgetUtilizationFactor_.getMean());
        super.send(this.brokerName_, 0.0, -1);
        super.shutdownUserEntity();
    }
}

