/*
 * Decompiled with CFR 0.152.
 */
package gridbroker;

import eduni.simjava.Sim_event;
import gridsim.Accumulator;
import gridsim.GridSim;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class ReportWriter
extends GridSim {
    private int numUser_;
    private int numResource_;
    private String reportFilename_;
    private double[] colValue_;
    private String[] statCategory_;
    private boolean newGridReportFlag_;
    private boolean matrixReportNextRowFlag_;
    private double rowValue_;

    public ReportWriter(String string, int n, int n2, String string2, String[] stringArray, boolean bl, double[] dArray, boolean bl2, double d) throws Exception {
        super(string);
        this.numUser_ = n;
        this.numResource_ = n2;
        this.reportFilename_ = string2;
        this.statCategory_ = stringArray;
        this.newGridReportFlag_ = bl;
        this.colValue_ = dArray;
        this.matrixReportNextRowFlag_ = bl2;
        this.rowValue_ = d;
    }

    public void body() {
        Sim_event sim_event = new Sim_event();
        this.sim_get_next(sim_event);
        while (sim_event.get_tag() != -1) {
            System.out.println("ReportWriter.body() : Unwanted event.");
            this.sim_get_next(sim_event);
        }
        this.generateReport();
        super.shutdownGridStatisticsEntity();
    }

    private void generateReport() {
        try {
            FileWriter fileWriter = new FileWriter(this.reportFilename_, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            printWriter.print(this.numUser_ + "\t" + this.numResource_);
            int n = this.statCategory_.length;
            for (int i = 0; i < n; ++i) {
                super.send(GridSim.getGridStatisticsEntityId(), 0.0, 11, (Object)this.statCategory_[i]);
                Accumulator accumulator = (Accumulator)super.receiveEventObject();
                printWriter.print("\t" + accumulator.getMean());
                String string = this.reportFilename_ + "." + i;
                this.writeToCategoryReportFile(string, accumulator);
            }
            printWriter.println();
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("ReportWriter.generateReport() : Error - unable to open \"" + this.reportFilename_ + "\"");
        }
    }

    private void writeToCategoryReportFile(String string, Accumulator accumulator) {
        try {
            FileWriter fileWriter = new FileWriter(string, true);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            if (this.newGridReportFlag_) {
                printWriter.println();
                int n = this.colValue_.length;
                for (int i = 0; i < n; ++i) {
                    printWriter.print("\t" + this.colValue_[i]);
                }
            }
            if (this.matrixReportNextRowFlag_) {
                printWriter.println();
                printWriter.print(this.rowValue_ + "\t" + accumulator.getMean());
            } else {
                printWriter.print("\t" + accumulator.getMean());
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("ReportWriter.writeToCategoryReportFile() : Error - unable to open \"" + this.reportFilename_ + "\"");
        }
    }
}

