/*
 * Decompiled with CFR 0.152.
 */
package gridbroker;

import gridsim.Accumulator;
import gridsim.GridSim;
import gridsim.Gridlet;
import gridsim.GridletList;

public class Experiment {
    private int id_;
    private GridletList glList_;
    private boolean dbFactorFlag_;
    private double dFactor_;
    private double bFactor_;
    private double deadline_;
    private double budget_;
    private double startTime_;
    private double endTime_;
    private String reportFile_;
    private String[] resNameList_;
    private int optStrategy_;
    public static final int OPTIMIZE_COST = 0;
    public static final int OPTIMIZE_COST_PLUS = 1;
    public static final int OPTIMIZE_COST_TIME = 2;
    public static final int OPTIMIZE_TIME = 3;
    public static final int OPTIMIZE_NONE = 4;

    public Experiment(int n, GridletList gridletList, int n2, boolean bl, double d, double d2, String string, String[] stringArray) {
        this.id_ = n;
        this.glList_ = gridletList;
        this.optStrategy_ = n2;
        this.dbFactorFlag_ = bl;
        if (this.dbFactorFlag_) {
            this.dFactor_ = d;
            this.bFactor_ = d2;
        } else {
            this.deadline_ = d;
            this.budget_ = d2;
        }
        this.reportFile_ = string;
        this.resNameList_ = stringArray;
        this.startTime_ = 0.0;
        this.endTime_ = 0.0;
    }

    public int GetID() {
        return this.getExperimentID();
    }

    public int getExperimentID() {
        return this.id_;
    }

    public GridletList GetGridletList() {
        return this.getGridletList();
    }

    public GridletList getGridletList() {
        return this.glList_;
    }

    public String[] GetResourcesNameList() {
        return this.getResourceNameList();
    }

    public String[] getResourceNameList() {
        return this.resNameList_;
    }

    public int GetOptimizationStrategy() {
        return this.getOptimizationStrategy();
    }

    public int getOptimizationStrategy() {
        return this.optStrategy_;
    }

    public String GetOptimizationStrategyName() {
        return this.getOptimizationStrategyName();
    }

    public String getOptimizationStrategyName() {
        String string = null;
        switch (this.optStrategy_) {
            case 0: {
                string = "OPTIMIZE_COST";
                break;
            }
            case 1: {
                string = "OPTIMIZE_COST_PLUS";
                break;
            }
            case 2: {
                string = "OPTIMIZE_COST_TIME";
                break;
            }
            case 3: {
                string = "OPTIMIZE_TIME";
                break;
            }
            case 4: {
                string = "OPTIMIZE_NONE";
                break;
            }
        }
        return string;
    }

    public boolean Get_DB_factor_flag() {
        return this.getFactorFlag();
    }

    public boolean getFactorFlag() {
        return this.dbFactorFlag_;
    }

    public double GetB_factor() {
        return this.getBudgetFactor();
    }

    public double getBudgetFactor() {
        return this.bFactor_;
    }

    public double GetD_factor() {
        return this.getDeadlineFactor();
    }

    public double getDeadlineFactor() {
        return this.dFactor_;
    }

    public void SetDeadline(double d) {
        this.setDeadline(d);
    }

    public void setDeadline(double d) {
        this.deadline_ = d;
    }

    public double GetDeadline() {
        return this.getDeadline();
    }

    public double getDeadline() {
        return this.deadline_;
    }

    public double GetDeadlineTime() {
        return this.getDeadlineTime();
    }

    public double getDeadlineTime() {
        return this.startTime_ + this.deadline_;
    }

    public void SetBudget(double d) {
        this.setBudget(d);
    }

    public void setBudget(double d) {
        this.budget_ = d;
    }

    public double GetBudget() {
        return this.getBudget();
    }

    public double getBudget() {
        return this.budget_;
    }

    public void SetDeadlineBudget(double d, double d2) {
        this.setDeadlineBudget(d, d2);
    }

    public void setDeadlineBudget(double d, double d2) {
        this.deadline_ = d;
        this.budget_ = d2;
    }

    public String GetReportFileName() {
        return this.getReportFileName();
    }

    public String getReportFileName() {
        return this.reportFile_;
    }

    public void SetStartTime() {
        this.setStartTime();
    }

    public void setStartTime() {
        this.startTime_ = GridSim.clock();
    }

    public double GetStartTime() {
        return this.getStartTime();
    }

    public double getStartTime() {
        return this.startTime_;
    }

    public void SetEndTime() {
        this.setEndTime();
    }

    public void setEndTime() {
        this.endTime_ = GridSim.clock();
    }

    public double GetEndTime() {
        return this.getEndTime();
    }

    public double getEndTime() {
        return this.endTime_;
    }

    public int GetNoOfGridlets() {
        return this.getNumGridlet();
    }

    public int getNumGridlet() {
        return this.glList_.size();
    }

    public double GetBudgetSpent() {
        return this.getBudgetSpent();
    }

    public double getBudgetSpent() {
        double d = 0.0;
        for (int i = 0; i < this.glList_.size(); ++i) {
            Gridlet gridlet = (Gridlet)this.glList_.get(i);
            if (gridlet.getGridletStatus() != 4) continue;
            d += gridlet.getActualCPUTime() * gridlet.getCostPerSec();
        }
        return d;
    }

    public int GetNoOfSuccessfulGridlets() {
        return this.getNumSuccessfulGridlet();
    }

    public int getNumSuccessfulGridlet() {
        int n = 0;
        for (int i = 0; i < this.glList_.size(); ++i) {
            Gridlet gridlet = (Gridlet)this.glList_.get(i);
            if (gridlet.getGridletStatus() != 4) continue;
            ++n;
        }
        return n;
    }

    public boolean IsSuccessful() {
        return this.isSuccessful();
    }

    public boolean isSuccessful() {
        return this.getNumSuccessfulGridlet() == this.getNumGridlet();
    }

    public double GridletCompletionFactor() {
        return this.getGridletCompletionFactor();
    }

    public double getGridletCompletionFactor() {
        double d = 0.0;
        int n = this.getNumGridlet();
        if (n != 0) {
            d = (double)this.getNumSuccessfulGridlet() / (double)n;
        }
        return d;
    }

    public double TimeUtilizationFactor() {
        return this.getTimeUtilFactor();
    }

    public double getTimeUtilFactor() {
        return (this.endTime_ - this.startTime_) / this.deadline_;
    }

    public double BudgetUtilizationFactor() {
        return this.getBudgetUtilFactor();
    }

    public double getBudgetUtilFactor() {
        return this.getBudgetSpent() / this.budget_;
    }

    public Accumulator GetAllGridletsLengthAccumulator() {
        return this.getAllGridletLengthAccumulator();
    }

    public Accumulator getAllGridletLengthAccumulator() {
        Accumulator accumulator = new Accumulator();
        for (int i = 0; i < this.glList_.size(); ++i) {
            accumulator.add(((Gridlet)this.glList_.get(i)).getGridletLength());
        }
        return accumulator;
    }
}

