/*
 * Decompiled with CFR 0.152.
 */
package eduni.simjava.distributions;

import eduni.simjava.distributions.ContinuousGenerator;
import eduni.simjava.distributions.Sim_beta_obj;
import eduni.simjava.distributions.Sim_negexp_obj;
import eduni.simjava.distributions.Sim_parameter_exception;
import eduni.simjava.distributions.Sim_random_obj;

public class Sim_gamma_obj
implements ContinuousGenerator {
    private Sim_random_obj source;
    private double scale;
    private double shape;
    private String name;

    public Sim_gamma_obj(String string, double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new Sim_parameter_exception("Sim_gamma_obj: The scale and shape parameters must be greater than 0.");
        }
        this.source = new Sim_random_obj("Internal PRNG");
        this.scale = d;
        this.shape = d2;
        this.name = string;
    }

    public Sim_gamma_obj(String string, double d, double d2, long l) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new Sim_parameter_exception("Sim_gamma_obj: The scale and shape parameters must be greater than 0.");
        }
        this.source = new Sim_random_obj("Internal PRNG", l);
        this.scale = d;
        this.shape = d2;
        this.name = string;
    }

    public double sample() {
        double d;
        if (this.shape == (double)((long)this.shape)) {
            double d2 = 1.0;
            long l = 0L;
            while (l < (long)this.shape) {
                d2 *= this.source.sample();
                ++l;
            }
            d = -this.scale * Math.log(d2);
        } else {
            d = this.shape < 1.0 ? this.scale * Sim_beta_obj.sample(this.source, this.shape, 1.0 - this.shape) * Sim_negexp_obj.sample(this.source, 1.0) : Sim_gamma_obj.sample(this.source, this.scale, (long)this.shape) + Sim_gamma_obj.sample(this.source, this.scale, this.shape - (double)((long)this.shape));
        }
        return d;
    }

    static double sample(Sim_random_obj sim_random_obj, double d, double d2) {
        double d3;
        if (d2 == (double)((long)d2)) {
            double d4 = 1.0;
            long l = 0L;
            while (l < (long)d2) {
                d4 *= sim_random_obj.sample();
                ++l;
            }
            d3 = -d * Math.log(d4);
        } else {
            d3 = d2 < 1.0 ? d * Sim_beta_obj.sample(sim_random_obj, d2, 1.0 - d2) * Sim_negexp_obj.sample(sim_random_obj, 1.0) : Sim_gamma_obj.sample(sim_random_obj, d, (long)d2) + Sim_gamma_obj.sample(sim_random_obj, d, d2 - (double)((long)d2));
        }
        return d3;
    }

    public void set_seed(long l) {
        this.source.set_seed(l);
    }

    public long get_seed() {
        return this.source.get_seed();
    }

    public String get_name() {
        return this.name;
    }
}

