/*
 * Decompiled with CFR 0.152.
 */
package eduni.simjava.distributions;

import eduni.simjava.distributions.ContinuousGenerator;
import eduni.simjava.distributions.Sim_parameter_exception;
import eduni.simjava.distributions.Sim_random_obj;

public class Sim_beta_obj
implements ContinuousGenerator {
    private Sim_random_obj source;
    private double shape_a;
    private double shape_b;
    private String name;

    public Sim_beta_obj(String string, double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new Sim_parameter_exception("Sim_beta_obj: The shape parameters must be greater than 0.");
        }
        this.source = new Sim_random_obj("Internal PRNG");
        this.shape_a = d;
        this.shape_b = d2;
        this.name = string;
    }

    public Sim_beta_obj(String string, double d, double d2, long l) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new Sim_parameter_exception("Sim_beta_obj: The shape parameters must be greater than 0.");
        }
        this.source = new Sim_random_obj("Internal PRNG", l);
        this.shape_a = d;
        this.shape_b = d2;
        this.name = string;
    }

    public double sample() {
        double d;
        if (this.shape_a == 1.0) {
            d = 1.0 - Math.pow(this.source.sample(), 1.0 / this.shape_b);
        } else if (this.shape_b == 1.0) {
            d = Math.pow(this.source.sample(), 1.0 / this.shape_a);
        } else if (this.shape_a > 1.0 || this.shape_b > 1.0) {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9 = this.shape_a + this.shape_b;
            double d10 = Math.min(this.shape_a, this.shape_b);
            double d11 = d10 <= 1.0 ? 1.0 / d10 : Math.sqrt((d9 - 2.0) / (2.0 * this.shape_a * this.shape_b - d9));
            double d12 = this.shape_a + 1.0 / this.shape_b;
            do {
                d5 = this.source.sample();
                d3 = this.source.sample();
                d2 = this.source.sample();
            } while ((d8 = d9 * Math.log(d9 / (d11 + (d7 = d9 * Math.exp(d6 = d11 * Math.log(d5 / (1.0 - d5)))))) + d12 * d6 - Math.log(4.0)) < (d4 = Math.log(d5 * d3 * d2)));
            d = d7 / (d11 + d7);
        } else {
            double d13;
            double d14;
            double d15;
            double d16;
            do {
                d15 = this.source.sample();
                d13 = this.source.sample();
            } while ((d16 = Math.pow(d15, 1.0 / this.shape_a)) + (d14 = Math.pow(d13, 1.0 / this.shape_b)) > 1.0);
            d = d16 / (d16 + d14);
        }
        return d;
    }

    static double sample(Sim_random_obj sim_random_obj, double d, double d2) {
        double d3;
        if (d == 1.0) {
            d3 = 1.0 - Math.pow(sim_random_obj.sample(), 1.0 / d2);
        } else if (d2 == 1.0) {
            d3 = Math.pow(sim_random_obj.sample(), 1.0 / d);
        } else if (d > 1.0 || d2 > 1.0) {
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            double d9;
            double d10;
            double d11 = d + d2;
            double d12 = Math.min(d, d2);
            double d13 = d12 <= 1.0 ? 1.0 / d12 : Math.sqrt((d11 - 2.0) / (2.0 * d * d2 - d11));
            double d14 = d + 1.0 / d2;
            do {
                d7 = sim_random_obj.sample();
                d5 = sim_random_obj.sample();
                d4 = sim_random_obj.sample();
            } while ((d10 = d11 * Math.log(d11 / (d13 + (d9 = d11 * Math.exp(d8 = d13 * Math.log(d7 / (1.0 - d7)))))) + d14 * d8 - Math.log(4.0)) < (d6 = Math.log(d7 * d5 * d4)));
            d3 = d9 / (d13 + d9);
        } else {
            double d15;
            double d16;
            double d17;
            double d18;
            do {
                d17 = sim_random_obj.sample();
                d15 = sim_random_obj.sample();
            } while ((d18 = Math.pow(d17, 1.0 / d)) + (d16 = Math.pow(d15, 1.0 / d2)) > 1.0);
            d3 = d18 / (d18 + d16);
        }
        return d3;
    }

    public void set_seed(long l) {
        this.source.set_seed(l);
    }

    public long get_seed() {
        return this.source.get_seed();
    }

    public String get_name() {
        return this.name;
    }
}

