/*
 * Decompiled with CFR 0.152.
 */
package eduni.simdiag;

import eduni.simdiag.GraphClearObject;
import eduni.simdiag.GraphData;
import eduni.simdiag.GraphDisplay;
import eduni.simdiag.GraphEventObject;
import eduni.simdiag.GraphListener;
import eduni.simdiag.GraphSetAxes;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class GraphLoader
implements Runnable {
    transient Thread thread;
    String urlName;
    private List graphListeners = new ArrayList();

    public GraphLoader(String string) {
        this.urlName = string;
        this.thread = new Thread(this);
    }

    public void startLoading() {
        this.thread.start();
    }

    protected String nextLine(BufferedReader bufferedReader) {
        try {
            String string = bufferedReader.readLine();
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void run() {
        String string;
        DataInputStream dataInputStream;
        URL uRL;
        try {
            uRL = new URL(this.urlName);
        }
        catch (Exception exception) {
            System.out.println("Can't open URL " + this.urlName);
            return;
        }
        try {
            dataInputStream = new DataInputStream(uRL.openStream());
        }
        catch (IOException iOException) {
            System.out.println("Couldn't open URL\n");
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
        int n = 0;
        this.forwardGraph(new GraphClearObject(this));
        String string2 = this.nextLine(bufferedReader);
        String string3 = this.nextLine(bufferedReader);
        this.forwardGraph(new GraphSetAxes(this, string2, string3));
        while ((string = this.nextLine(bufferedReader)) != null) {
            this.forwardGraph(new GraphData(this, string));
            ++n;
        }
        this.forwardGraph(new GraphDisplay(this));
        System.out.println("Read in " + n + " lines");
    }

    public synchronized void addGraphListener(GraphListener graphListener) {
        this.graphListeners.add(graphListener);
    }

    public synchronized void removeGraphListener(GraphListener graphListener) {
        this.graphListeners.remove(graphListener);
    }

    public void forwardGraph(GraphEventObject graphEventObject) {
        List list;
        GraphLoader graphLoader = this;
        synchronized (graphLoader) {
            list = (List)((ArrayList)this.graphListeners).clone();
        }
        int n = 0;
        while (n < list.size()) {
            GraphListener graphListener = (GraphListener)list.get(n);
            graphListener.handleGraph(graphEventObject);
            ++n;
        }
    }
}

